#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

package require Gnocl


set label [gnocl::image -image "%/button_highlighter_orange.png"]
set box [gnocl::eventBox -child $label -tooltip "Helpful hint"]


set toolBar [gnocl::toolBar]
set hl [$toolBar add item -icon "%/button_highlighter_orange.png" -onClicked exit]

puts $hl

proc change {w i} {
   eval ::$w configure -icon "%%/$i"
   eval $::label configure -image "%/$i"
}

#---------------
set menuBar [gnocl::menuBar]
set menu [gnocl::menu -tearoff 0]
$menu add [gnocl::menuItem -icon "%/highlighter_yellow.png" \
   -onClicked {change $hl button_highlighter_yellow.png} ]
$menu add [gnocl::menuItem -icon "%/highlighter_cyan.png" \
   -onClicked {change $hl button_highlighter_cyan.png} ]
$menu add [gnocl::menuItem -icon "%/highlighter_pink.png" \
   -onClicked {change $hl button_highlighter_pink.png} ]
$menu add [gnocl::menuItem -icon "%/highlighter_orange.png" \
   -onClicked {change $hl button_highlighter_orange.png} ]
$menu add [gnocl::menuItem -icon "%/highlighter_blue.png" \
   -onClicked {change $hl button_highlighter_blue.png} ]
$menu add [gnocl::menuItem -icon "%/highlighter_green.png" \
   -onClicked {change $hl button_highlighter_green.png} ]

$menuBar add [gnocl::menuItem -icon "%/downarrow.png" -submenu $menu]

#---------------

$toolBar add widget $menuBar
$toolBar add widget $box

set h2 [$toolBar add item -icon "%/highlighter.png" -onClicked exit]

gnocl::window -title "ToolBar" -child $toolBar

gnocl::mainLoop
